#ifndef __CAboutWindow__
#define __CAboutWindow__

#include "CWindow.hpp"
using Exponent::GUI::Windowing::CWindow;

namespace Exponent
{
	namespace GUI
	{
		namespace Windowing
		{
			/**
			 * @class CAboutWindow CAboutWindow.hpp
			 * @brief ABout window that is set to the centre of the screen
			 *
			 * @date 05/02/2006
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CAboutWindow.hpp,v 1.5 2007/02/08 21:07:54 paul Exp $
			 */
			class CAboutWindow : public CWindow
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================

			public:

//	===========================================================================

				/**
				 * Construction
				 * @param aboutWindowImagePath The path to the image to load as the about display
				 * @param imageName The name of the image (eg About.tga)
				 * @param alpha The alpha level for the window
				 */
				CAboutWindow(const CSystemString &aboutWindowImagePath, const CString imageName, const double alpha);

				/**
				 * Construction using an image from the image manager named "AboutWindow"
				 * @param alpha The alpha level for the window
				 */
				CAboutWindow(const double alpha);

				/**
				 * Destruction
				 */
				virtual ~CAboutWindow();

//	===========================================================================

				/**
				 * Lost focus
				 * @param window The window that lost the focus
				 */
				virtual void lostFocus(IWindow *window);

//	===========================================================================
				
				#ifndef WIN32
					/**
					 * Handle the window being opened
					 */
					virtual void openWindow();
				#endif

//	===========================================================================

			protected:

//	===========================================================================

				/**
				 * @class CAboutRoot CAboutWindow.hpp
				 * @brief Replacement control root that closes the window on click
				 */
				class CAboutRoot : public CControlRoot
				{
				public:

					/**
					 * Construction
					 * @param parent the parent window
					 */
					CAboutRoot(IWindow *parent) : CControlRoot(parent) { }

					/**
					 * Destruction
					 */
					virtual ~CAboutRoot() { }

					/**
					 * Handle left button being clicked
					 * @param event the event to handle
					 */
					virtual void handleLeftButtonDown(CMouseEvent &event) { m_parentWindow->closeWindow(); }

				};
			};
		}
	}
}
#endif			// End of CAboutWindow.hpp